(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[     13970,        359]
NotebookOptionsPosition[     10921,        296]
NotebookOutlinePosition[     11524,        316]
CellTagsIndexPosition[     11481,        313]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["C| Tips and tricks", "Section",
 CellFrame->{{0.5, 3}, {3, 0.5}},
 CellChangeTimes->{{3.9643174291306467`*^9, 3.964317437438129*^9}, {
   3.9648868284499207`*^9, 3.964886833698546*^9}, 3.9687226853821173`*^9, 
   3.9728201768136997`*^9},
 FontColor->GrayLevel[
  0],ExpressionUUID->"b674563b-d9b3-459e-b398-baf66b29e4c7"],

Cell["\<\
Here is a collection of odd tips that you may find useful, in no particular \
order.\
\>", "Text",
 CellChangeTimes->{{3.972820096018037*^9, 
  3.972820141443437*^9}},ExpressionUUID->"6d3c0d92-dad0-46d9-abb8-\
16b9642e3d7b"],

Cell["\<\
Note Some cells that have been included for illustration purposes have the \
property that they are not evaluatable. If these are copied and pasted into \
another nb they will not evaluate unless the cell properties are changed!\
\>", "Item",
 CellChangeTimes->{{3.964413201352008*^9, 
  3.964413323496501*^9}},ExpressionUUID->"2bbbab59-a53c-41b4-b33a-\
f67c948415cf"],

Cell[CellGroupData[{

Cell["Displacement over determined", "Subsubsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.9643185543965607`*^9, 3.964318560616539*^9}, {
  3.9728329505133266`*^9, 
  3.972832954007679*^9}},ExpressionUUID->"7e1b9a6a-e8e9-4f0c-9c4e-\
1168b2df3d8a"],

Cell["\<\
Sometimes, you may find the displacement seems over determined i.e. more \
equations than variables. whilst this is normally due to a syntax error or \
error in the boundary conditions, If there is no obvious reason, try clearing \
the following variables in case they are previously defined.\
\>", "Item",
 CellChangeTimes->{{3.96140695896012*^9, 3.961407066770516*^9}, {
  3.964318436525104*^9, 
  3.9643184816432753`*^9}},ExpressionUUID->"12d67ccb-016b-4d79-aaa7-\
c68886209d3d"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"x", ",", "y", ",", "z", ",", "u", ",", "v", ",", "w"}], 
  "]"}]], "Input",
 CellLabel->
  "In[456]:=",ExpressionUUID->"bff602f6-0cae-4c8a-bd66-08924791470b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Meshing", "Subsubsection",
 CellChangeTimes->{{3.964318570608697*^9, 
  3.964318572618814*^9}},ExpressionUUID->"600d4c33-e539-48f0-829f-\
665fc1bd2d53"],

Cell["\<\
Try and avoid very thin elements as these control the number of  elements and \
hence the time taken to run.\
\>", "Text",
 CellChangeTimes->{{3.964318584143141*^9, 
  3.9643186423185987`*^9}},ExpressionUUID->"b82a759d-65dc-44bc-9b56-\
0e16566f03cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Point element markers on edges and corners", "Subsubsection",
 CellChangeTimes->{{3.973823252673914*^9, 3.9738232668972187`*^9}},
 CellID->758245679,ExpressionUUID->"bdd5d4d2-5db2-4609-822f-2fa2f1fae36f"],

Cell[TextData[{
 "Dirichlet conditions are applied to point elements. Not to surfaces, \
although they may appear to be the same. Careful inspection  of the ",
 StyleBox["ElementMarker", "inTextCode"],
 " will indicate where these are. At corners they may exist on one face or \
the other. Where it is important you can control where they are put by adding \
an option to the ",
 StyleBox["ToElementMesh", "inTextCode"],
 ", called ",
 StyleBox["\[OpenCurlyDoubleQuote]PointMarker\[CloseCurlyDoubleQuote]-> \
\[OpenCurlyDoubleQuote]BoundaryDeduced\[CloseCurlyDoubleQuote].", 
  "inTextCode"],
 " You can find an example by pasting ",
 StyleBox["ToElementMesh#954199870 ", "inTextCode"],
 "into the documentation search. With that, points on edges and in corners \
get their own distinct marker and can be combined as required."
}], "Text",
 CellChangeTimes->{{3.973822323296929*^9, 3.973822486718348*^9}, {
  3.973822539926317*^9, 3.973822566910061*^9}, {3.9738226724850693`*^9, 
  3.973822781684182*^9}, {3.9738228262000437`*^9, 3.9738230444344893`*^9}, {
  3.973823200800432*^9, 3.973823224673135*^9}, {3.9738232942815123`*^9, 
  3.973823314537056*^9}, {3.9738235838699837`*^9, 3.973823586000041*^9}},
 CellID->988838976,ExpressionUUID->"d2fb1db3-dfb0-4a50-9121-9a2bf8deee42"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Using a Macintosh, you may, very occasionally, get this error message.\
\>", "Subsubsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.964411739430436*^9, 3.964411742133301*^9}, {
  3.9728199067267847`*^9, 
  3.972819955056622*^9}},ExpressionUUID->"24aefa78-b531-4bf9-bb26-\
1940dea5df13"],

Cell["\<\
FindRoot::jsing1 : Encountered a singular Jacobian at the point {0., 0., 0., \
0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., << 11 >>, \
0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., \
<< 121078 >>} . Try perturbing the initial point (s) . FindRoot::sszero : The \
step size in the search has become less than the tolerance prescribed by the \
PrecisionGoal option, but the function value is still greater than the \
tolerance prescribed by the AccuracyGoal option .\
\>", "Text",
 CellChangeTimes->{{3.963890174600576*^9, 3.963890176787856*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"8d603e75-8909-4fb3-865e-cef6bbc8744a"],

Cell["\<\
If so then change the Method in NDSolve as follows. This will be resolved in \
version 15,\
\>", "Text",
 CellChangeTimes->{{3.964411768445017*^9, 3.964411773634243*^9}, {
  3.97281997030942*^9, 
  3.97282005020715*^9}},ExpressionUUID->"c04f4e1e-f189-4972-b0f2-\
a53463253f35"],

Cell[BoxData[
 RowBox[{"displacementWithSprings", "=", 
  RowBox[{"NDSolveValue", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"op", "==", "loads"}], ",", 
      RowBox[{"Dirchlet", " ", "conditions"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
      RowBox[{"v", "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "}"}], ",", 
    RowBox[{"Element", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "mesh"}], "]"}], ",", 
    RowBox[{"Method", "->", 
     RowBox[{"{", 
      RowBox[{"\"\<PDEDiscretization\>\"", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<FiniteElement\>\"", ",", 
         RowBox[{"\"\<PDESolveOptions\>\"", "->", 
          RowBox[{"{", 
           RowBox[{"\"\<LinearSolver\>\"", "->", "\"\<MUMPS\>\""}], "}"}]}]}],
         "}"}]}], "}"}]}]}], "]"}]}]], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.963889626651286*^9, 3.9638896273320627`*^9}, 
   3.963889671756412*^9, {3.963889716423705*^9, 3.963889740380055*^9}, {
   3.9644117829655*^9, 3.964411814568124*^9}, {3.972833214878442*^9, 
   3.972833216430073*^9}},ExpressionUUID->"87890d34-1a78-413b-bd14-\
604353092870"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compression only springs", "Subsubsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.964411963985855*^9, 
  3.9644119705699577`*^9}},ExpressionUUID->"53680be0-d3f7-4d2b-9d03-\
1a0273ca3f72"],

Cell["\<\
Define a spring constant 
Then Boundary condition, for a spring in the w direction, becomes\
\>", "Text",
 CellChangeTimes->{{3.9644119851821327`*^9, 3.964412036177658*^9}, 
   3.972819846829102*^9, {3.9728331619935513`*^9, 
   3.972833190860219*^9}},ExpressionUUID->"53adb56d-4359-4a7e-aa14-\
1bfda0bf6e8c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"found", "=", 
   RowBox[{"NeumannValue", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "springConstant"}], " ", 
      RowBox[{"w", "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"z", "-", "0"}], "]"}], "<", 
      SuperscriptBox["10", 
       RowBox[{"-", "5"}]]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->
  "In[457]:=",ExpressionUUID->"f0e3fc7b-eb1f-4320-9715-dbd7f5d5bb72"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Max or Min over a region", "Subsubsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.964778198391818*^9, 
  3.96477820526567*^9}},ExpressionUUID->"c8c9882c-9159-467c-a683-\
3a41e9ff10a8"],

Cell["\<\
To find the maximum over a region use NMaxValue[]   Similarly NMinValue[]\
\>", "Text",
 CellChangeTimes->{{3.964777873787925*^9, 3.9647779261193247`*^9}, {
  3.9647782163506117`*^9, 
  3.964778216588106*^9}},ExpressionUUID->"463611ea-77f1-4bf8-a2e8-\
78f9464cc9e8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Region Properties", "Subsubsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.972833451997717*^9, 
  3.9728334621306334`*^9}},ExpressionUUID->"8349923c-06ad-4a2a-9ec6-\
dc91a13457cf"],

Cell["The following properties are available for a mesh region", "Text",
 CellChangeTimes->{{3.972833487666761*^9, 
  3.972833519432033*^9}},ExpressionUUID->"f0395c1f-3c15-4b48-8625-\
ad4ea892dea5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"meshProperties", "=", 
  RowBox[{"mesh", "[", "\"\<Properties\>\"", "]"}]}]], "Input",
 CellChangeTimes->{3.968494990468028*^9, 3.9728335269111*^9},
 CellID->652271300,ExpressionUUID->"82c96efb-425b-40e3-844e-dffcf065122a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"BoundaryConnectivity\"\>", 
   ",", "\<\"BoundaryElementMarkerUnion\"\>", ",", "\<\"BoundaryElements\"\>",
    ",", "\<\"BoundaryNormals\"\>", ",", "\<\"Bounds\"\>", 
   ",", "\<\"ContinuousElementConnectivity\"\>", ",", "\<\"Coordinates\"\>", 
   ",", "\<\"ElementConnectivity\"\>", ",", "\<\"EmbeddingDimension\"\>", 
   ",", "\<\"HangingNodes\"\>", ",", "\<\"LengthUnit\"\>", 
   ",", "\<\"MeshElementMarkerUnion\"\>", ",", "\<\"MeshElements\"\>", 
   ",", "\<\"MeshOrder\"\>", ",", "\<\"NumberOfBoundaryElements\"\>", 
   ",", "\<\"NumberOfCoordinates\"\>", ",", "\<\"NumberOfMeshElements\"\>", 
   ",", "\<\"NumberOfPointElements\"\>", 
   ",", "\<\"PointElementMarkerUnion\"\>", ",", "\<\"PointElements\"\>", 
   ",", "\<\"Properties\"\>", ",", "\<\"Quality\"\>", 
   ",", "\<\"RegionHoles\"\>", ",", "\<\"VertexBoundaryConnectivity\"\>", 
   ",", "\<\"VertexElementConnectivity\"\>"}], "}"}]], "Output",
 CellFrame->{{0, 0}, {2, 0}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{3.968494991672117*^9, 3.968663814991837*^9},
 CellLabel->"Out[37]=",
 CellID->1541987927,ExpressionUUID->"a5d0bde7-4688-47c9-a592-7206c7fcc5e0"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{932, 911},
WindowMargins->{{130, Automatic}, {Automatic, 133}},
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "MyBookStyles.nb"]]}, Visible -> False, 
  FrontEndVersion -> "14.3 for Mac OS X ARM (64-bit) (July 8, 2025)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"],
ExpressionUUID->"e30125be-3080-4922-841b-7cf8f623270a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 327, 6, 49, "Section",ExpressionUUID->"b674563b-d9b3-459e-b398-baf66b29e4c7"],
Cell[906, 30, 234, 6, 25, "Text",ExpressionUUID->"6d3c0d92-dad0-46d9-abb8-16b9642e3d7b"],
Cell[1143, 38, 378, 7, 41, "Item",ExpressionUUID->"2bbbab59-a53c-41b4-b33a-f67c948415cf"],
Cell[CellGroupData[{
Cell[1546, 49, 296, 6, 37, "Subsubsection",ExpressionUUID->"7e1b9a6a-e8e9-4f0c-9c4e-1168b2df3d8a"],
Cell[1845, 57, 492, 9, 41, "Item",ExpressionUUID->"12d67ccb-016b-4d79-aaa7-c68886209d3d"],
Cell[2340, 68, 207, 5, 25, "Input",ExpressionUUID->"bff602f6-0cae-4c8a-bd66-08924791470b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2584, 78, 158, 3, 25, "Subsubsection",ExpressionUUID->"600d4c33-e539-48f0-829f-665fc1bd2d53"],
Cell[2745, 83, 260, 6, 25, "Text",ExpressionUUID->"b82a759d-65dc-44bc-9b56-0e16566f03cb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3042, 94, 210, 2, 25, "Subsubsection",ExpressionUUID->"bdd5d4d2-5db2-4609-822f-2fa2f1fae36f",
 CellID->758245679],
Cell[3255, 98, 1278, 22, 90, "Text",ExpressionUUID->"d2fb1db3-dfb0-4a50-9121-9a2bf8deee42",
 CellID->988838976]
}, Open  ]],
Cell[CellGroupData[{
Cell[4570, 125, 344, 8, 37, "Subsubsection",ExpressionUUID->"24aefa78-b531-4bf9-bb26-1940dea5df13"],
Cell[4917, 135, 704, 11, 93, "Text",ExpressionUUID->"8d603e75-8909-4fb3-865e-cef6bbc8744a"],
Cell[5624, 148, 287, 7, 25, "Text",ExpressionUUID->"c04f4e1e-f189-4972-b0f2-a53463253f35"],
Cell[5914, 157, 1392, 35, 73, "Input",ExpressionUUID->"87890d34-1a78-413b-bd14-604353092870",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[7343, 197, 241, 5, 37, "Subsubsection",ExpressionUUID->"53680be0-d3f7-4d2b-9d03-1a0273ca3f72"],
Cell[7587, 204, 318, 7, 41, "Text",ExpressionUUID->"53adb56d-4359-4a7e-aa14-1bfda0bf6e8c"],
Cell[7908, 213, 490, 15, 27, "Input",ExpressionUUID->"f0e3fc7b-eb1f-4320-9715-dbd7f5d5bb72"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8435, 233, 238, 5, 37, "Subsubsection",ExpressionUUID->"c8c9882c-9159-467c-a683-3a41e9ff10a8"],
Cell[8676, 240, 276, 6, 25, "Text",ExpressionUUID->"463611ea-77f1-4bf8-a2e8-78f9464cc9e8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8989, 251, 234, 5, 37, "Subsubsection",ExpressionUUID->"8349923c-06ad-4a2a-9ec6-dc91a13457cf"],
Cell[9226, 258, 198, 3, 25, "Text",ExpressionUUID->"f0395c1f-3c15-4b48-8625-ad4ea892dea5"],
Cell[CellGroupData[{
Cell[9449, 265, 247, 4, 25, "Input",ExpressionUUID->"82c96efb-425b-40e3-844e-dffcf065122a",
 CellID->652271300],
Cell[9699, 271, 1182, 20, 86, "Output",ExpressionUUID->"a5d0bde7-4688-47c9-a592-7206c7fcc5e0",
 CellID->1541987927]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

